<?php
/**
 * Error Log Viewer
 * Check what's causing the 500 error
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

?>
<!DOCTYPE html>
<html>
<head>
    <title>Error Log - SourceHub</title>
    <style>
        body {
            font-family: monospace;
            max-width: 900px;
            margin: 20px auto;
            padding: 20px;
            background: #1e1e1e;
            color: #d4d4d4;
        }
        .container {
            background: #252526;
            padding: 20px;
            border-radius: 5px;
            border-left: 4px solid #667eea;
        }
        h1 {
            color: #667eea;
        }
        .info {
            background: #333;
            padding: 10px;
            margin: 10px 0;
            border-radius: 3px;
        }
        .error {
            color: #f48771;
        }
        .success {
            color: #6a9955;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>SourceHub - Error Log & Diagnostics</h1>
        <hr>
        
        <h2>System Information</h2>
        <div class="info">
            <strong>PHP Version:</strong> <?php echo phpversion(); ?><br>
            <strong>OS:</strong> <?php echo php_uname(); ?><br>
            <strong>Current File:</strong> <?php echo __FILE__; ?><br>
            <strong>Server Software:</strong> <?php echo $_SERVER['SERVER_SOFTWARE']; ?><br>
        </div>
        
        <h2>Common Issues & Solutions</h2>
        <div class="info">
            <h3 class="error">HTTP 500 Error - Checklist:</h3>
            <ol>
                <li>
                    <strong>Check Database Connection</strong><br>
                    <a href="setup.php" style="color: #667eea;">Run Setup Test →</a>
                </li>
                <li>
                    <strong>Check PHP Error Logs</strong><br>
                    Location: /home/YOUR_USERNAME/public_html/error_log<br>
                    (Ask your hosting provider for access)
                </li>
                <li>
                    <strong>Verify Database Credentials</strong><br>
                    cPanel → MySQL Databases → Check username and password
                </li>
                <li>
                    <strong>Check File Permissions</strong><br>
                    Files should be 644, Folders should be 755
                </li>
                <li>
                    <strong>Enable PHP Debug Mode</strong><br>
                    cPanel → PHP Configuration → Display Errors
                </li>
            </ol>
        </div>
        
        <h2>What To Do Next</h2>
        <div class="info">
            <strong>Step 1:</strong> Go to <a href="setup.php" style="color: #667eea;">setup.php</a><br>
            <strong>Step 2:</strong> Update database credentials if needed<br>
            <strong>Step 3:</strong> Run the test<br>
            <strong>Step 4:</strong> If it works, go back to <a href="index.php" style="color: #667eea;">index.php</a><br>
        </div>
        
        <hr>
        <p style="font-size: 12px; color: #888;">
            If you're still getting errors, contact your hosting support with this information.
        </p>
    </div>
</body>
</html>
